
/**
 ******************************************************************************
 *
 * @file        MG32x02z_ScanKey_API.h
 * @brief       This file contains all the functions prototypes for scan key 
 *              firmware library.
 *
 * @par         Project
 *              MG32x02z
 * @version     V1.02
 * @date        2022/09/26
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef _MG32x02z_ScanKey_API_
#define _MG32x02z_ScanKey_API_

/* Includes ------------------------------------------------------------------*/
#include "MG32x02z_ADC_MID.h"
#include "MG32x02z_TM_MID.h"
#include "MG32x02z_GPIO_DRV.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/** 
 * @enum        ADC_AnalyzKey
 * @brief       Analysis ADC Key matrix 
 */        
typedef enum
{
    Key0        = 0x0001,              /*!< Serial Key0 */
    Key0_Push   = 0x0001,
    Key0_Pop    = 0x8001,
    Key1        = 0x0002,              /*!< Serial Key1 */
    Key1_Push   = 0x0002,
    Key1_Pop    = 0x8002,
    Key2        = 0x0003,              /*!< Serial Key2 */
    Key2_Push   = 0x0003,
    Key2_Pop    = 0x8003,
    Key3        = 0x0004,              /*!< Serial Key3 */
    Key3_Push   = 0x0004,
    Key3_Pop    = 0x8004,
    Key4        = 0x0005,              /*!< Serial Key4 */
    Key4_Push   = 0x0005,
    Key4_Pop    = 0x8005,
    Key5        = 0x0006,              /*!< Serial Key5 */
    Key5_Push   = 0x0006,
    Key5_Pop    = 0x8006,
    Key6        = 0x0007,              /*!< Serial Key6 */
    Key6_Push   = 0x0007,
    Key6_Pop    = 0x8007,
    Key7        = 0x0008,              /*!< Serial Key7 */
    Key7_Push   = 0x0008,
    Key7_Pop    = 0x8008,
    Key8        = 0x0009,              /*!< Serial Key8 */
    Key8_Push   = 0x0009,
    Key8_Pop    = 0x8009,

    Key10       = 0x000A,             /*!< Parelle Key10 */
    Key10_Push  = 0x000A,
    Key10_Pop   = 0x800A,
    Key11       = 0x000B,             /*!< Parelle Key11 */
    Key11_Push  = 0x000B,
    Key11_Pop   = 0x800B,
    Key12       = 0x000C,             /*!< Parelle Key12 */
    Key12_Push  = 0x000C,
    Key12_Pop   = 0x800C,

//    Key10_Key11 = 0x0600,       /*!< Parelle Key10+Key11 */
//    Key10_Key12 = 0x0A00,       /*!< Parelle Key10+Key12 */
//    Key11_Key12 = 0x0C00,       /*!< Parelle Key11+Key12 */
//    Key10_Key11_Key12 = 0x0E00, /*!< Parelle Key10+Key11+Key12 */

    NoPressKey = 0x0000,        /*!< Did not press any button */
} MatrixKeyDef;

/* Private define ------------------------------------------------------------*/
#define ScanKey_Voltage     3.3         /*!< Voltage */ 
#define AllowDiffPressure   0.02        /*!< ~0.02 V */
#define ADCResolution       4095        /*!< 12 bit */

/**
 * @name    Praellel Key0 (Key10)
 *          Information control by ADC sample
 */ 
///@{  
#define PKey0_Target        1.65        /*!< Press PKey0 then ADC will get voltage */ 
#define PKey0_LV            (PKey0_Target-AllowDiffPressure)/ScanKey_Voltage*ADCResolution
#define PKey0_HV            (PKey0_Target+AllowDiffPressure)/ScanKey_Voltage*ADCResolution
///@}

/**
 * @name    Praellel Key1 (Key11)
 *          Information control by ADC sample
 */ 
///@{  
#define PKey1_Target        2.25        /*!< Press PKey1 then ADC will get voltage */ 
#define PKey1_LV            (PKey1_Target-AllowDiffPressure)/ScanKey_Voltage*ADCResolution
#define PKey1_HV            (PKey1_Target+AllowDiffPressure)/ScanKey_Voltage*ADCResolution
///@}

/**
 * @name    Praellel Key2 (Key12)
 *          Information control by ADC sample
 */ 
///@{  
#define PKey2_Target        2.79        /*!< Press PKey2 then ADC will get voltage */ 
#define PKey2_LV            (PKey2_Target-AllowDiffPressure)/ScanKey_Voltage*ADCResolution
#define PKey2_HV            (PKey2_Target+AllowDiffPressure)/ScanKey_Voltage*ADCResolution
///@}

/**
 * @name    Praellel Key0+Key1 (Key10+Key11)
 *          Information control by ADC sample
 */ 
///@{  
#define PKey01_Target       1.34        /*!< Press PKey0+Pkey1 then ADC will get voltage */ 
#define PKey01_LV           (PKey01_Target-AllowDiffPressure)/ScanKey_Voltage*ADCResolution
#define PKey01_HV           (PKey01_Target+AllowDiffPressure)/ScanKey_Voltage*ADCResolution
///@}

/**
 * @name    Praellel Key0+Key2 (Key10+Key12)
 *          Information control by ADC sample
 */ 
///@{  
#define PKey02_Target       1.51        /*!< Press PKey0+Pkey2 then ADC will get voltage */ 
#define PKey02_LV           (PKey02_Target-AllowDiffPressure)/ScanKey_Voltage*ADCResolution
#define PKey02_HV           (PKey02_Target+AllowDiffPressure)/ScanKey_Voltage*ADCResolution
///@}

/**
 * @name    Praellel Key1+Key2 (Key11+Key12)
 *          Information control by ADC sample
 */ 
///@{  
#define PKey12_Target       2.00        /*!< Press PKey1+Pkey2 then ADC will get voltage */ 
#define PKey12_LV           (PKey12_Target-AllowDiffPressure)/ScanKey_Voltage*ADCResolution
#define PKey12_HV           (PKey12_Target+AllowDiffPressure)/ScanKey_Voltage*ADCResolution
///@}

/**
 * @name    Praellel Key0+Key1+Key2 (Key10+Key11+Key12)
 *          Information control by ADC sample
 */ 
///@{  
#define PKey012_Target      1.24        /*!< Press PKey0+PKey1+Pkey2 then ADC will get voltage */ 
#define PKey012_LV          (PKey012_Target-AllowDiffPressure)/ScanKey_Voltage*ADCResolution
#define PKey012_HV          (PKey012_Target+AllowDiffPressure)/ScanKey_Voltage*ADCResolution
///@}



/**
 * @name    Serial Key1 (Key1)
 *          Information control by ADC sample
 */ 
///@{  
#define SKey1_Target        0.36        /*!< Press SKey1 then ADC will get voltage */ 
#define SKey1_LV            (SKey1_Target-AllowDiffPressure)/ScanKey_Voltage*ADCResolution
#define SKey1_HV            (SKey1_Target+AllowDiffPressure)/ScanKey_Voltage*ADCResolution
///@}

/**
 * @name    Serial Key2 (Key2)
 *          Information control by ADC sample
 */ 
///@{  
#define SKey2_Target        0.73        /*!< Press SKey2 then ADC will get voltage */ 
#define SKey2_LV            (SKey2_Target-AllowDiffPressure)/ScanKey_Voltage*ADCResolution
#define SKey2_HV            (SKey2_Target+AllowDiffPressure)/ScanKey_Voltage*ADCResolution
///@}

/**
 * @name    Serial Key3 (Key3)
 *          Information control by ADC sample
 */ 
///@{  
#define SKey3_Target        1.10        /*!< Press SKey3 then ADC will get voltage */ 
#define SKey3_LV            (SKey3_Target-AllowDiffPressure)/ScanKey_Voltage*ADCResolution
#define SKey3_HV            (SKey3_Target+AllowDiffPressure)/ScanKey_Voltage*ADCResolution
///@}

/**
 * @name    Serial Key4 (Key4)
 *          Information control by ADC sample
 */ 
///@{  
#define SKey4_Target        1.48        /*!< Press SKey4 then ADC will get voltage */ 
#define SKey4_LV            (SKey4_Target-AllowDiffPressure)/ScanKey_Voltage*ADCResolution
#define SKey4_HV            (SKey4_Target+AllowDiffPressure)/ScanKey_Voltage*ADCResolution
///@}

/**
 * @name    Serial Key5 (Key5)
 *          Information control by ADC sample
 */ 
///@{  
#define SKey5_Target        1.84        /*!< Press SKey5 then ADC will get voltage */ 
#define SKey5_LV            (SKey5_Target-AllowDiffPressure)/ScanKey_Voltage*ADCResolution
#define SKey5_HV            (SKey5_Target+AllowDiffPressure)/ScanKey_Voltage*ADCResolution
///@}

/**
 * @name    Serial Key6 (Key6)
 *          Information control by ADC sample
 */ 
///@{  
#define SKey6_Target        2.23        /*!< Press SKey6 then ADC will get voltage */ 
#define SKey6_LV            (SKey6_Target-AllowDiffPressure)/ScanKey_Voltage*ADCResolution
#define SKey6_HV            (SKey6_Target+AllowDiffPressure)/ScanKey_Voltage*ADCResolution
///@}

/**
 * @name    Serial Key7 (Key7)
 *          Information control by ADC sample
 */ 
///@{  
#define SKey7_Target        2.58        /*!< Press SKey7 then ADC will get voltage */ 
#define SKey7_LV            (SKey7_Target-AllowDiffPressure)/ScanKey_Voltage*ADCResolution
#define SKey7_HV            (SKey7_Target+AllowDiffPressure)/ScanKey_Voltage*ADCResolution
///@}

/**
 * @name    Serial Key8 (Key8)
 *          Information control by ADC sample
 */ 
///@{  
#define SKey8_Target        2.97        /*!< Press SKey8 then ADC will get voltage */ 
#define SKey8_LV            (SKey8_Target-AllowDiffPressure)/ScanKey_Voltage*ADCResolution
#define SKey8_HV            (SKey8_Target+AllowDiffPressure)/ScanKey_Voltage*ADCResolution
///@}

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
void API_ADC_Init(void);
uint16_t API_ADC_GetSerialKey(void);
uint16_t API_ADC_GetParallelKey(void);

/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
extern ADC_HandleTypeDef   mADC;
extern TM_HandleTypeDef    mTM20;

/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/


#endif
